% Coded by Tian You on 2022/9/7

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ar2rc}[2022/09/07 Author response to reviewer comment class]
\LoadClass{article}

\RequirePackage[a4paper, top=25.4mm, bottom=25.4mm, left=19mm, right=19mm, headheight = 1cm, footskip=1.75cm]{geometry}

% Typography
\RequirePackage[T1]{fontenc}
\RequirePackage{times}
\RequirePackage{mathptmx} % math also in times font
\RequirePackage{amssymb,amsmath}
\RequirePackage{microtype}
\RequirePackage[utf8]{inputenc}

% Misc
\RequirePackage{graphicx}
\RequirePackage{hyperref} 
\RequirePackage{soul} % Highlight using \hl{}

% Table
\RequirePackage{adjustbox} % center large tables across textwidth by surrounding tabular with \begin{adjustbox}{center}
\renewcommand{\arraystretch}{1.5} % enlarge spacing between rows
\RequirePackage{caption} 
\captionsetup[table]{skip=10pt} % enlarge spacing between caption and table

% Section styles
\RequirePackage{titlesec}
\titleformat{\section}{\normalfont \large \it }{}{0em}{\bfseries}
\titlespacing{\section}{0em}{1em}{0em} % left before after
\renewcommand\thesubsection{\arabic{subsection}}
\titleformat{\subsection}{\normalfont\it}{\rm \makebox[0pt][r]{(\thesubsection) \hspace{2mm}}}{0em}{}
\titlespacing{\subsection}{3em}{0em}{0em} % left before after

% Paragraph styles
\RequirePackage{changepage} 
\setlength{\parskip}{1.0\baselineskip}%
\setlength{\parindent}{0em}%
% \setlength{\leftskip}{3.5em}
\newenvironment{response}{\begin{adjustwidth}{3em}{}}{\end{adjustwidth}}

% Quotation styles
\RequirePackage{mdframed}
\renewmdenv[leftmargin=3.0em, rightmargin=0em%
innerleftmargin=0.6em,innerrightmargin=0.6em]{quote}

% Table styles
\let\oldtabular=\tabular
\let\endoldtabular=\endtabular
\renewenvironment{tabular}[1]{\begin{adjustbox}{center}\begin{oldtabular}{#1}}{\end{oldtabular}\end{adjustbox}}

% Shortcuts
%% Let textbf be both, bold and italic
%\DeclareTextFontCommand{\textbf}{\bfseries\em}

%%%
%DIF PREAMBLE EXTENSION ADDED BY LATEXDIFF
%DIF UNDERLINE PREAMBLE %DIF PREAMBLE
\RequirePackage[normalem]{ulem} %DIF PREAMBLE
\RequirePackage{xcolor}
\providecommand{\DIFadd}[1]{{\protect\color{red}{#1}}} %DIF PREAMBLE
\providecommand{\DIFdel}[1]{{\protect\color{blue}\sout{#1}}}                      %DIF PREAMBLE
%DIF SAFE PREAMBLE %DIF PREAMBLE
\providecommand{\DIFaddbegin}{} %DIF PREAMBLE
\providecommand{\DIFaddend}{} %DIF PREAMBLE
\providecommand{\DIFdelbegin}{} %DIF PREAMBLE
\providecommand{\DIFdelend}{} %DIF PREAMBLE
%DIF FLOATSAFE PREAMBLE %DIF PREAMBLE
\providecommand{\DIFaddFL}[1]{\DIFadd{#1}} %DIF PREAMBLE
\providecommand{\DIFdelFL}[1]{\DIFdel{#1}} %DIF PREAMBLE
\providecommand{\DIFaddbeginFL}{} %DIF PREAMBLE
\providecommand{\DIFaddendFL}{} %DIF PREAMBLE
\providecommand{\DIFdelbeginFL}{} %DIF PREAMBLE
\providecommand{\DIFdelendFL}{} %DIF PREAMBLE
%DIF END PREAMBLE EXTENSION ADDED BY LATEXDIFF

% Define title defaults if not defined by user

\let\@header\@empty
\let\@journal\@empty
\let\@editor\@empty
\let\@editorlocation\@empty
\let\@letterdate\@empty
\newcommand{\header}[1]{\gdef\@header{#1}}
\newcommand{\journal}[1]{\gdef\@journal{#1}}
\newcommand{\editor}[1]{\gdef\@editor{#1}}
\newcommand{\editorlocation}[1]{\gdef\@editorlocation{#1}}
\newcommand{\letterdate}[1]{\gdef\@letterdate{#1}}

% header and footer
\RequirePackage{fancyhdr}
\RequirePackage{lastpage}
\RequirePackage{transparent}
\pagestyle{fancy}
\fancyhf{} % clear existing header/footer entries
\renewcommand{\headrulewidth}{0pt}
\fancyfoot[C]{\footnotesize Page \thepage\ of \pageref*{LastPage}}

\fancypagestyle{firststyle}
{
   \fancyhf{}
   \fancyhead[C]{\fontsize{8.5}{9.5} \selectfont
    \transparent{0.5} \includegraphics[height=1.5cm]{icon}\\ \@header}
   \fancyfoot[C]{\footnotesize Page \thepage\ of \pageref*{LastPage}}
   \renewcommand{\headrulewidth}{0pt}
}

% Make title and legend
\RequirePackage{transparent}
\renewcommand\maketitle{
\noindent \\ \\
{\@letterdate}\\ \\
{\@editor}\\
{\@journal}\\
{\@editorlocation}\\ \\
{\centerline{\underline{\@title}}}
}

% signature
\newcommand{\signature}{\noindent Sincerely, \\ {\@author}}

% font size
\renewcommand{\normalsize}{\fontsize{11}{15.6}\selectfont}